-- SQL schema for QR Order System
CREATE DATABASE IF NOT EXISTS qr_order_system CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
USE qr_order_system;

CREATE TABLE users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  username VARCHAR(100) NOT NULL UNIQUE,
  password_hash VARCHAR(255) NOT NULL,
  role VARCHAR(50) NOT NULL DEFAULT 'admin',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE tables_store (
  id INT AUTO_INCREMENT PRIMARY KEY,
  table_name VARCHAR(50) NOT NULL,
  status ENUM('free','in_service','paying') NOT NULL DEFAULT 'free',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE menu (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(150) NOT NULL,
  image_url VARCHAR(255) DEFAULT NULL,
  price DECIMAL(10,2) NOT NULL DEFAULT 0,
  category VARCHAR(100) DEFAULT NULL,
  is_active TINYINT(1) DEFAULT 1,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE orders_table (
  id INT AUTO_INCREMENT PRIMARY KEY,
  table_id INT NOT NULL,
  status ENUM('open','paying','closed') NOT NULL DEFAULT 'open',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (table_id) REFERENCES tables_store(id) ON DELETE CASCADE
);

CREATE TABLE order_items (
  id INT AUTO_INCREMENT PRIMARY KEY,
  order_id INT NOT NULL,
  menu_id INT NOT NULL,
  qty INT NOT NULL DEFAULT 1,
  delivered_qty INT NOT NULL DEFAULT 0,
  price DECIMAL(10,2) NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (order_id) REFERENCES orders_table(id) ON DELETE CASCADE,
  FOREIGN KEY (menu_id) REFERENCES menu(id) ON DELETE CASCADE
);

CREATE TABLE plans (
  id INT AUTO_INCREMENT PRIMARY KEY,
  plan_name VARCHAR(50) NOT NULL,
  max_tables INT NOT NULL,
  max_scans_per_month INT NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE shop_usage (
  id INT AUTO_INCREMENT PRIMARY KEY,
  month INT NOT NULL,
  year INT NOT NULL,
  scan_count INT NOT NULL DEFAULT 0,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  UNIQUE KEY (month, year)
);

-- NOTE: Replace {REPLACE_PASSWORD_HASH} below with output of PHP password_hash('your_password', PASSWORD_DEFAULT)
INSERT INTO users (username, password_hash, role) VALUES ('admin', '{REPLACE_PASSWORD_HASH}', 'admin');

INSERT INTO plans (plan_name, max_tables, max_scans_per_month) VALUES
('free', 5, 1000),
('pro', 10, 10000),
('enterprise', 20, 20000);

INSERT INTO tables_store (table_name) VALUES ('T01'),('T02'),('T03'),('T04'),('T05');

INSERT INTO menu (name, image_url, price, category) VALUES
('Americano', '', 2.50, 'Coffee'),
('Latte', '', 3.50, 'Coffee'),
('Matcha Latte', '', 3.80, 'Tea'),
('Green Tea', '', 2.00, 'Tea');
