(async function(){
  const params = new URLSearchParams(location.search);
  const table = params.get('table') || 'Unknown';
  const token = params.get('v') || '';
  document.getElementById('tableName').textContent = table;

  const scanResp = await fetch('../api/track_scan.php', {
    method: 'POST',
    headers: {'Content-Type':'application/json'},
    body: JSON.stringify({table, token})
  }).then(r => r.json());

  const scanStatus = document.getElementById('scanStatus');
  if (!scanResp.success) {
    scanStatus.textContent = 'Scan blocked: ' + (scanResp.error || 'limit exceeded');
    document.getElementById('menuSection').style.display = 'none';
    document.getElementById('checkoutBtn').disabled = true;
    return;
  } else {
    scanStatus.textContent = `Welcome! Remaining scans this month: ${scanResp.remaining}`;
  }

  async function loadMenu(){
    const data = await fetch('../api/get_menu.php').then(r => r.json());
    if (!data.success) { alert('Failed to load menu'); return; }
    const list = document.getElementById('menuList');
    list.innerHTML = '';
    data.menu.forEach(item => {
      const el = document.createElement('div');
      el.className = 'menu-item';
      el.innerHTML = `
        <img src="${item.image_url||'https://via.placeholder.com/80'}" alt="" width="80" height="80">
        <div>
        <strong>${item.name}</strong><br/>
        <span>$${parseFloat(item.price).toFixed(2)}</span><br/>
        <button class="minus">-</button>
        <span class="qty">0</span>
        <button class="plus">+</button>
        </div>
      `;
      const qtyEl = el.querySelector('.qty');
      el.querySelector('.plus').addEventListener('click', () => {
        let q = parseInt(qtyEl.textContent) || 0; q++; qtyEl.textContent = q;
        updateCart(item.id, item.name, item.price, q);
      });
      el.querySelector('.minus').addEventListener('click', () => {
        let q = parseInt(qtyEl.textContent) || 0; if (q>0) q--; qtyEl.textContent = q;
        updateCart(item.id, item.name, item.price, q);
      });
      list.appendChild(el);
    });
  }

  const CART_KEY = `cart_${table}`;
  function getCart(){ return JSON.parse(localStorage.getItem(CART_KEY) || '[]'); }
  function saveCart(c){ localStorage.setItem(CART_KEY, JSON.stringify(c)); renderCart(); }
  function updateCart(menu_id, name, price, qty){
    let cart = getCart();
    const idx = cart.findIndex(x=>x.menu_id==menu_id);
    if (idx === -1 && qty>0) cart.push({menu_id, name, price, qty});
    else if (idx !== -1) {
      if (qty>0) cart[idx].qty = qty;
      else cart.splice(idx,1);
    }
    saveCart(cart);
  }

  function renderCart(){
    const cur = document.getElementById('currentOrder');
    const totalEl = document.getElementById('totalPrice');
    const cart = getCart();
    cur.innerHTML = '';
    let total = 0;
    cart.forEach(it => {
      const div = document.createElement('div');
      div.textContent = `${it.name} x ${it.qty} = $${(it.price*it.qty).toFixed(2)}`;
      cur.appendChild(div);
      total += it.price * it.qty;
    });
    totalEl.textContent = total.toFixed(2);
  }

  document.getElementById('checkoutBtn').addEventListener('click', async () => {
    const cart = getCart();
    if (!cart.length) return alert('Cart empty');
    const payload = {table, items: cart};
    const res = await fetch('../api/create_order.php', {
      method: 'POST', headers: {'Content-Type':'application/json'}, body: JSON.stringify(payload)
    }).then(r => r.json());
    if (!res.success) return alert('Order failed: ' + (res.error || ''));
    localStorage.removeItem(CART_KEY);
    renderCart();
    alert('Order placed. Thank you!');
  });

  await loadMenu();
  renderCart();
})();