<?php
header('Content-Type: application/json');
$input = json_decode(file_get_contents('php://input'), true);
require __DIR__ . '/../config/db.php';
$cfg = require __DIR__ . '/../config/settings.php';

$table = $input['table'] ?? null;
$token = $input['token'] ?? $input['v'] ?? null;
if (!$table || !$token) {
    echo json_encode(['success'=>false,'error'=>'table & token required']);
    exit;
}

$decoded = base64_decode(strtr($token, '-_', '+/'));
if ($decoded === false) { echo json_encode(['success'=>false,'error'=>'Invalid token']); exit; }
$parts = explode('|', $decoded);
if (count($parts) !== 2) { echo json_encode(['success'=>false,'error'=>'Invalid token format']); exit; }
$payloadJson = $parts[0];
$hmac = $parts[1];
$expected = hash_hmac('sha256', $payloadJson, $cfg['signing_secret']);
if (!hash_equals($expected, $hmac)) { echo json_encode(['success'=>false,'error'=>'Invalid token signature']); exit; }

$payload = json_decode($payloadJson, true);
if (!$payload || ($payload['table'] ?? null) !== $table) { echo json_encode(['success'=>false,'error'=>'Token payload mismatch']); exit; }
if (isset($payload['exp']) && time() > intval($payload['exp'])) { echo json_encode(['success'=>false,'error'=>'Token expired']); exit; }

$month = intval(date('n'));
$year = intval(date('Y'));

try {
    $pdo->beginTransaction();
    $stmt = $pdo->prepare("SELECT id, scan_count FROM shop_usage WHERE month = :m AND year = :y LIMIT 1");
    $stmt->execute(['m'=>$month,'y'=>$year]);
    $row = $stmt->fetch();
    if ($row) {
        $usage_id = $row['id'];
        $scan_count = $row['scan_count'];
    } else {
        $pdo->prepare("INSERT INTO shop_usage (month, year, scan_count) VALUES (:m, :y, 0)")->execute(['m'=>$month,'y'=>$year]);
        $usage_id = $pdo->lastInsertId();
        $scan_count = 0;
    }

    $plan_id = $cfg['default_plan_id'] ?? 1;
    $stmt = $pdo->prepare("SELECT max_scans_per_month FROM plans WHERE id = :id LIMIT 1");
    $stmt->execute(['id'=>$plan_id]);
    $plan = $stmt->fetch();
    $limit = $plan ? intval($plan['max_scans_per_month']) : 1000;

    if ($scan_count + 1 > $limit) {
        $pdo->commit();
        echo json_encode(['success'=>false,'error'=>'monthly_limit','remaining'=>0]);
        exit;
    }

    $pdo->prepare("UPDATE shop_usage SET scan_count = scan_count + 1 WHERE id = :id")->execute(['id'=>$usage_id]);
    $pdo->commit();

    echo json_encode(['success'=>true,'remaining'=> max(0, $limit - ($scan_count+1)) ]);
} catch (Exception $e) {
    $pdo->rollBack();
    echo json_encode(['success'=>false,'error'=>$e->getMessage()]);
}
