<?php
header('Content-Type: application/json');
require __DIR__ . '/../config/db.php';

$table = $_GET['table'] ?? null;
if (!$table) { echo json_encode(['success'=>false,'error'=>'table required']); exit; }

$stmt = $pdo->prepare("
SELECT o.id as order_id, o.created_at, o.status,
  oi.id as item_id, oi.menu_id, m.name, oi.qty, oi.delivered_qty, oi.price
FROM orders_table o
LEFT JOIN order_items oi ON oi.order_id = o.id
LEFT JOIN menu m ON m.id = oi.menu_id
WHERE o.table_id = (SELECT id FROM tables_store WHERE table_name = :t)
ORDER BY o.created_at DESC, oi.created_at DESC
");
$stmt->execute(['t'=>$table]);
$rows = $stmt->fetchAll();
echo json_encode(['success'=>true,'rows'=>$rows]);
