<?php
header('Content-Type: application/json');
$input = json_decode(file_get_contents('php://input'), true);
require __DIR__ . '/../config/db.php';
$cfg = require __DIR__ . '/../config/settings.php';

$tableName = $input['table'] ?? null;
$items = $input['items'] ?? [];

if (!$tableName || empty($items)) {
    echo json_encode(['success'=>false,'error'=>'Table and items required']);
    exit;
}

$stmt = $pdo->prepare("SELECT id FROM tables_store WHERE table_name = :t");
$stmt->execute(['t'=>$tableName]);
$row = $stmt->fetch();
if (!$row) {
    echo json_encode(['success'=>false,'error'=>'Table not found']);
    exit;
}
$table_id = $row['id'];

try {
    $pdo->beginTransaction();
    $stmt = $pdo->prepare("SELECT id FROM orders_table WHERE table_id = :tid AND status='open' LIMIT 1");
    $stmt->execute(['tid'=>$table_id]);
    $o = $stmt->fetch();
    if ($o) {
        $order_id = $o['id'];
    } else {
        $stmt = $pdo->prepare("INSERT INTO orders_table (table_id, status) VALUES (:tid, 'open')");
        $stmt->execute(['tid'=>$table_id]);
        $order_id = $pdo->lastInsertId();
    }

    $insert = $pdo->prepare("INSERT INTO order_items (order_id, menu_id, qty, delivered_qty, price) VALUES (:oid, :mid, :qty, 0, :price)");
    foreach ($items as $it) {
        $menu_id = intval($it['menu_id']);
        $qty = intval($it['qty']);
        $price = floatval($it['price']);
        if ($qty <= 0) continue;
        $insert->execute(['oid'=>$order_id,'mid'=>$menu_id,'qty'=>$qty,'price'=>$price]);
    }
    $pdo->prepare("UPDATE tables_store SET status='in_service' WHERE id = :id")->execute(['id'=>$table_id]);
    $pdo->commit();
    echo json_encode(['success'=>true,'order_id'=>$order_id]);
} catch (Exception $e) {
    $pdo->rollBack();
    echo json_encode(['success'=>false,'error'=>$e->getMessage()]);
}
