<?php
header('Content-Type: application/json');
$input = json_decode(file_get_contents('php://input'), true);
require __DIR__ . '/../config/db.php';

$table = $input['table'] ?? null;
$menu_id = $input['menu_id'] ?? null;
$qty = intval($input['qty'] ?? 1);
$price = floatval($input['price'] ?? 0);

if (!$table || !$menu_id || $qty<=0) { echo json_encode(['success'=>false,'error'=>'Invalid input']); exit; }

$stmt = $pdo->prepare("SELECT id FROM tables_store WHERE table_name = :t");
$stmt->execute(['t'=>$table]);
$row = $stmt->fetch();
if (!$row) { echo json_encode(['success'=>false,'error'=>'Table not found']); exit; }
$table_id = $row['id'];

try {
    $pdo->beginTransaction();
    $stmt = $pdo->prepare("SELECT id FROM orders_table WHERE table_id = :tid AND status='open' LIMIT 1");
    $stmt->execute(['tid'=>$table_id]);
    $o = $stmt->fetch();
    if ($o) $order_id = $o['id'];
    else {
        $pdo->prepare("INSERT INTO orders_table (table_id,status) VALUES (:tid,'open')")->execute(['tid'=>$table_id]);
        $order_id = $pdo->lastInsertId();
    }
    $ins = $pdo->prepare("INSERT INTO order_items (order_id, menu_id, qty, delivered_qty, price) VALUES (:oid, :mid, :qty, 0, :price)");
    $ins->execute(['oid'=>$order_id,'mid'=>$menu_id,'qty'=>$qty,'price'=>$price]);
    $pdo->commit();
    echo json_encode(['success'=>true,'order_id'=>$order_id]);
} catch (Exception $e) {
    $pdo->rollBack();
    echo json_encode(['success'=>false,'error'=>$e->getMessage()]);
}
