<?php
session_start();
$cfg = require __DIR__ . '/../config/settings.php';
require __DIR__ . '/../config/db.php';
if (empty($_SESSION[$cfg['auth']['session_name']])) {
    header('Location: login.php'); exit;
}
$table_id = intval($_GET['table_id'] ?? 0);
if (!$table_id) { echo 'Table id required'; exit; }

$stmt = $pdo->prepare("SELECT table_name, status FROM tables_store WHERE id = :id");
stmt->execute(['id'=>$table_id]);
$table = $stmt->fetch();
if (!$table) { echo 'Table not found'; exit; }
?>
<!doctype html>
<html>
<head><meta charset="utf-8"><title>Table <?=$table['table_name']?></title>
<link rel="stylesheet" href="../public/assets/css/style.css"></head>
<body>
<h2>Table <?=$table['table_name']?> (status: <?=$table['status']?>)</h2>
<div id="orders"></div>
<script>
async function load(){
  const res = await fetch('../api/get_table_orders.php?table=' + encodeURIComponent('<?=$table['table_name']?>'));
  const j = await res.json();
  const el = document.getElementById('orders');
  if(!j.success){ el.textContent = j.error || 'Failed'; return; }
  el.innerHTML = '<pre>' + JSON.stringify(j.rows, null, 2) + '</pre>';
}
load();
</script>
</body>
</html>
