<?php
session_start();
$cfg = require __DIR__ . '/../config/settings.php';
require __DIR__ . '/../config/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    if (!$username || !$password) {
        $err = "Username & password required.";
    } else {
        $stmt = $pdo->prepare("SELECT id, username, password_hash FROM users WHERE username = :u");
        $stmt->execute(['u' => $username]);
        $user = $stmt->fetch();
        if ($user && password_verify($password, $user['password_hash'])) {
            $_SESSION[$cfg['auth']['session_name']] = [
                'id' => $user['id'],
                'username' => $user['username']
            ];
            header('Location: index.php');
            exit;
        } else {
            $err = "Invalid credentials.";
        }
    }
}
?>
<!doctype html>
<html>
<head><meta charset="utf-8"><title>Admin Login</title></head>
<body>
<h2>Admin Login</h2>
<?php if (!empty($err)): ?><p style="color:red;"><?=htmlspecialchars($err)?></p><?php endif; ?>
<form method="post">
  <label>Username: <input name="username" /></label><br/>
  <label>Password: <input name="password" type="password" /></label><br/>
  <button type="submit">Login</button>
</form>
</body>
</html>
