<?php
session_start();
$cfg = require __DIR__ . '/../config/settings.php';
require __DIR__ . '/../config/db.php';

if (empty($_SESSION[$cfg['auth']['session_name']])) {
    header('Location: login.php');
    exit;
}

$stmt = $pdo->query("SELECT t.id, t.table_name, t.status,
  (SELECT COUNT(*) FROM orders_table o WHERE o.table_id = t.id AND o.status='open') as open_orders
  FROM tables_store t ORDER BY t.id");
$tables = $stmt->fetchAll();
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Admin Dashboard - <?=$cfg['app']['shop_name']?></title>
<link rel="stylesheet" href="../public/assets/css/style.css">
<script src="https://cdn.jsdelivr.net/npm/qrcode/build/qrcode.min.js"></script>
</head>
<body>
  <header>
    <h1><?=$cfg['app']['shop_name']?> — Admin</h1>
    <a href="logout.php">Logout</a>
  </header>

  <section>
    <h2>Tables</h2>
    <div class="table-grid">
      <?php foreach($tables as $t): ?>
        <div class="table-card" data-table-id="<?= $t['id'] ?>">
          <strong><?=htmlspecialchars($t['table_name'])?></strong><br/>
          Status: <em><?=htmlspecialchars($t['status'])?></em><br/>
          Open orders: <?=intval($t['open_orders'])?><br/>
          <button class="btn-gen" data-table="<?=htmlspecialchars($t['table_name'])?>">Generate QR</button>
          <button onclick="location.href='table_view.php?table_id=<?=$t['id']?>'">Open</button>
        </div>
      <?php endforeach; ?>
    </div>
  </section>

  <section>
    <h2>QR Generator (client-side)</h2>
    <p>Select a table then click Generate QR to request a signed token and render QR in your browser (PNG/SVG available).</p>
    <div id="qrArea"></div>
  </section>

<script>
document.addEventListener('click', async (ev) => {
  const btn = ev.target.closest('.btn-gen');
  if(!btn) return;
  const table = btn.dataset.table;
  try {
    const res = await fetch('generate_qr_token.php', {
      method: 'POST',
      headers: {'Content-Type':'application/json'},
      body: JSON.stringify({table})
    });
    const json = await res.json();
    if(!json.success) return alert(json.error || 'Failed to get token');
    const url = json.url;
    const qrArea = document.getElementById('qrArea');
    qrArea.innerHTML = '';
    const canvas = document.createElement('canvas');
    qrArea.appendChild(canvas);
    QRCode.toCanvas(canvas, url, {errorCorrectionLevel: 'H'}, function (err) {
      if (err) return alert('QR render error:'+err);
      const a = document.createElement('a');
      a.href = url; a.textContent = url; a.style.display='block';
      qrArea.appendChild(a);
      const btnD = document.createElement('button');
      btnD.textContent = 'Download PNG';
      btnD.addEventListener('click', () => {
        const dataURL = canvas.toDataURL('image/png');
        const link = document.createElement('a');
        link.href = dataURL;
        link.download = table + '.png';
        link.click();
      });
      qrArea.appendChild(btnD);
    });
  } catch (e) {
    alert('Error: ' + e);
  }
});
</script>
</body>
</html>
