<?php
session_start();
header('Content-Type: application/json');
$cfg = require __DIR__ . '/../config/settings.php';
require __DIR__ . '/../config/db.php';

if (empty($_SESSION[$cfg['auth']['session_name']])) {
    echo json_encode(['success'=>false,'error'=>'Not authorized']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$table = $input['table'] ?? null;
if (!$table) {
    echo json_encode(['success'=>false,'error'=>'Table required']);
    exit;
}

$stmt = $pdo->prepare("SELECT id FROM tables_store WHERE table_name = :t LIMIT 1");
$stmt->execute(['t' => $table]);
$row = $stmt->fetch();
if (!$row) {
    echo json_encode(['success'=>false,'error'=>'Table not found']);
    exit;
}

$expiry = time() + 60*60*24*365;
$payload = json_encode(['table' => $table, 'exp' => $expiry]);
$secret = $cfg['signing_secret'];
$hmac = hash_hmac('sha256', $payload, $secret);
$token = rtrim(strtr(base64_encode($payload . '|' . $hmac), '+/', '-_'), '=');

$url = rtrim($cfg['app']['base_url'], '/') . '/public/order.php?table=' . urlencode($table) . '&v=' . urlencode($token);

echo json_encode(['success'=>true,'url'=>$url]);
