<?php
require_once 'api/config.php';

$table = isset($_GET['table']) ? htmlspecialchars($_GET['table']) : 'Unknown';

// Track scan
$conn = getDB();
$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'];
$scanDate = date('Y-m-d');

$configResult = $conn->query("SELECT plan, current_month_scan_count FROM config LIMIT 1");
$config = $configResult->fetch_assoc();
$limits = getPlanLimits($config['plan']);

// Check limit
if ($config['current_month_scan_count'] >= $limits['scan']) {
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Limit Exceeded</title>
        <link rel="stylesheet" href="assets/css/style.css">
    </head>
    <body>
        <div class="limit-exceeded">
            <h1>⚠️ Scan Limit Exceeded</h1>
            <p>This shop has reached its monthly scan limit.</p>
            <p>Please contact the shop owner to upgrade their plan.</p>
        </div>
    </body>
    </html>
    <?php
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order - <?php echo $table; ?></title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div id="app">
        <div class="header">
            <div class="container">
                <h1 id="shopName">Loading...</h1>
                <div class="table-info">
                    <span>📍</span>
                    <span id="tableName"><?php echo $table; ?></span>
                </div>
            </div>
        </div>

        <div class="container">
            <!-- Current Orders -->
            <div id="currentOrders" class="section" style="display: none;">
                <h2>Your Orders</h2>
                <div id="ordersList"></div>
                <div class="total-section">
                    <span>Total</span>
                    <span id="ordersTotal">$0.00</span>
                </div>
            </div>

            <!-- Current Cart -->
            <div id="cartSection" class="section" style="display: none;">
                <h2>Current Cart</h2>
                <div id="cartItems"></div>
                <div class="total-section">
                    <span>Cart Total</span>
                    <span id="cartTotal">$0.00</span>
                </div>
                <button id="placeOrderBtn" class="btn btn-primary btn-block">Place Order</button>
            </div>

            <!-- Menu -->
            <div class="section">
                <h2>Menu</h2>
                <div id="menuList" class="menu-grid"></div>
            </div>
        </div>
    </div>

    <script>
        const TABLE_NAME = "<?php echo $table; ?>";
    </script>
    <script src="assets/js/customer.js"></script>
</body>
</html>