CREATE DATABASE IF NOT EXISTS coffee_ordering;
USE coffee_ordering;

-- Menu Table
CREATE TABLE menu (
    id INT PRIMARY KEY AUTO_INCREMENT,
    name VARCHAR(100) NOT NULL,
    image VARCHAR(255),
    price DECIMAL(10,2) NOT NULL,
    category VARCHAR(50),
    active TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Config Table
CREATE TABLE config (
    id INT PRIMARY KEY AUTO_INCREMENT,
    shop_name VARCHAR(100) DEFAULT 'Coffee Shop',
    plan ENUM('free', 'pro', 'enterprise') DEFAULT 'free',
    current_month_scan_count INT DEFAULT 0,
    last_reset_date DATE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Orders Table (Daily)
CREATE TABLE orders (
    id INT PRIMARY KEY AUTO_INCREMENT,
    order_date DATE NOT NULL,
    timestamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    table_name VARCHAR(50) NOT NULL,
    item_id INT,
    item_name VARCHAR(100),
    qty INT NOT NULL,
    price DECIMAL(10,2) NOT NULL,
    subtotal DECIMAL(10,2) NOT NULL,
    status ENUM('ongoing', 'delivered', 'completed') DEFAULT 'ongoing',
    order_group_id VARCHAR(50),
    INDEX idx_date_table (order_date, table_name),
    INDEX idx_status (status)
);

-- Tables Table
CREATE TABLE tables (
    id INT PRIMARY KEY AUTO_INCREMENT,
    name VARCHAR(50) NOT NULL UNIQUE,
    status ENUM('free', 'in-service', 'paying') DEFAULT 'free',
    qr_code VARCHAR(255),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Scan Tracking Table
CREATE TABLE scan_logs (
    id INT PRIMARY KEY AUTO_INCREMENT,
    table_name VARCHAR(50),
    scan_date DATE,
    scan_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    ip_address VARCHAR(45),
    user_agent TEXT,
    INDEX idx_scan_date (scan_date)
);

-- Insert Sample Menu Items
INSERT INTO menu (name, image, price, category) VALUES
('Espresso', 'https://via.placeholder.com/150/8B4513/FFFFFF?text=Espresso', 3.50, 'Coffee'),
('Cappuccino', 'https://via.placeholder.com/150/8B4513/FFFFFF?text=Cappuccino', 4.50, 'Coffee'),
('Latte', 'https://via.placeholder.com/150/8B4513/FFFFFF?text=Latte', 4.75, 'Coffee'),
('Americano', 'https://via.placeholder.com/150/8B4513/FFFFFF?text=Americano', 3.75, 'Coffee'),
('Green Tea', 'https://via.placeholder.com/150/228B22/FFFFFF?text=Green+Tea', 3.00, 'Tea'),
('Chai Latte', 'https://via.placeholder.com/150/D2691E/FFFFFF?text=Chai', 4.25, 'Tea'),
('Earl Grey', 'https://via.placeholder.com/150/708090/FFFFFF?text=Earl+Grey', 3.25, 'Tea'),
('Croissant', 'https://via.placeholder.com/150/FFD700/000000?text=Croissant', 3.50, 'Food'),
('Blueberry Muffin', 'https://via.placeholder.com/150/4169E1/FFFFFF?text=Muffin', 3.75, 'Food'),
('Chocolate Cake', 'https://via.placeholder.com/150/8B4513/FFFFFF?text=Cake', 5.50, 'Food');

-- Insert Default Config
INSERT INTO config (shop_name, plan, last_reset_date) VALUES
('Café Delight', 'pro', CURDATE());

-- Insert Sample Tables
INSERT INTO tables (name, qr_code) VALUES
('Table 1', 'QR_TABLE_1'),
('Table 2', 'QR_TABLE_2'),
('Table 3', 'QR_TABLE_3'),
('Table 4', 'QR_TABLE_4'),
('Table 5', 'QR_TABLE_5'),
('Table 6', 'QR_TABLE_6'),
('Table 7', 'QR_TABLE_7'),
('Table 8', 'QR_TABLE_8'),
('Table 9', 'QR_TABLE_9'),
('Table 10', 'QR_TABLE_10');