<?php
$cfg = require __DIR__ . '/../config/settings.php';
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title><?=htmlspecialchars($cfg['app']['shop_name'])?> — Order</title>
  <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
  <header>
    <h1><?=htmlspecialchars($cfg['app']['shop_name'])?></h1>
  </header>

  <main>
    <div id="info">
      <p>Table: <span id="tableName"></span></p>
      <p id="scanStatus"></p>
    </div>

    <section id="cartSection">
      <h3>Current Order</h3>
      <div id="currentOrder"></div>
      <div id="totalArea">Total: $<span id="totalPrice">0.00</span></div>
      <button id="checkoutBtn">Place Order</button>
    </section>

    <section id="menuSection">
      <h3>Menu</h3>
      <div id="menuList"></div>
    </section>
  </main>

<script src="assets/js/order.js"></script>
</body>
</html>
