<?php
require_once 'config.php';

$conn = getDB();

$data = json_decode(file_get_contents('php://input'), true);

$table = $conn->real_escape_string($data['table']);
$status = $conn->real_escape_string($data['status']);

if (!in_array($status, ['free', 'in-service', 'paying'])) {
    echo json_encode(['success' => false, 'error' => 'Invalid status']);
    exit;
}

// Update table status
$conn->query("
    INSERT INTO tables (name, status) VALUES ('$table', '$status')
    ON DUPLICATE KEY UPDATE status = '$status'
");

// If status is free, mark all orders as completed
if ($status === 'free') {
    $today = date('Y-m-d');
    $conn->query("
        UPDATE orders 
        SET status = 'completed' 
        WHERE table_name = '$table' 
        AND order_date = '$today'
        AND status != 'completed'
    ");
}

echo json_encode(['success' => true]);

$conn->close();
?>