<?php
header('Content-Type: application/json');
$input = json_decode(file_get_contents('php://input'), true);
require __DIR__ . '/../config/db.php';

$item_id = intval($input['item_id'] ?? 0);
$delivered_qty = isset($input['delivered_qty']) ? intval($input['delivered_qty']) : null;
$action = $input['action'] ?? null;

if (!$item_id) { echo json_encode(['success'=>false,'error'=>'item_id required']); exit; }

try {
    if ($action === 'remove') {
        $pdo->prepare("DELETE FROM order_items WHERE id = :id")->execute(['id'=>$item_id]);
    } elseif ($action === 'delivered') {
        if ($delivered_qty === null) { throw new Exception('delivered_qty required'); }
        $pdo->prepare("UPDATE order_items SET delivered_qty = :dq WHERE id = :id")->execute(['dq'=>$delivered_qty,'id'=>$item_id]);
    } elseif ($action === 'update_qty') {
        if ($delivered_qty === null) { throw new Exception('qty required'); }
        $pdo->prepare("UPDATE order_items SET qty = :q WHERE id = :id")->execute(['q'=>$delivered_qty,'id'=>$item_id]);
    } else {
        throw new Exception('Unknown action');
    }
    echo json_encode(['success'=>true]);
} catch (Exception $e) {
    echo json_encode(['success'=>false,'error'=>$e->getMessage()]);
}
