<?php
require_once 'config.php';

$conn = getDB();
checkResetScanCount($conn);

// Get table parameter
$table = isset($_GET['table']) ? $conn->real_escape_string($_GET['table']) : '';

if (empty($table)) {
    echo json_encode(['success' => false, 'error' => 'Table name required']);
    exit;
}

// Get config
$configResult = $conn->query("SELECT plan, current_month_scan_count FROM config LIMIT 1");
$config = $configResult->fetch_assoc();
$limits = getPlanLimits($config['plan']);

// Check scan limit
if ($config['current_month_scan_count'] >= $limits['scan']) {
    echo json_encode([
        'success' => false,
        'error' => 'Monthly scan limit exceeded',
        'limit_exceeded' => true
    ]);
    exit;
}

// Check table limit
$tableCount = $conn->query("SELECT COUNT(*) as count FROM tables")->fetch_assoc()['count'];
$tableResult = $conn->query("SELECT id FROM tables WHERE name = '$table'");

if ($tableResult->num_rows === 0 && $tableCount >= $limits['qr']) {
    echo json_encode([
        'success' => false,
        'error' => 'Table limit exceeded for your plan',
        'limit_exceeded' => true
    ]);
    exit;
}

// Log scan
$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'];
$scanDate = date('Y-m-d');

$stmt = $conn->prepare("INSERT INTO scan_logs (table_name, scan_date, ip_address, user_agent) VALUES (?, ?, ?, ?)");
$stmt->bind_param('ssss', $table, $scanDate, $ip, $userAgent);
$stmt->execute();

// Increment scan count
$conn->query("UPDATE config SET current_month_scan_count = current_month_scan_count + 1");

echo json_encode([
    'success' => true,
    'table' => $table,
    'scan_count' => $config['current_month_scan_count'] + 1,
    'scan_limit' => $limits['scan']
]);

$conn->close();
?>