<?php
require_once 'config.php';

$conn = getDB();

$data = json_decode(file_get_contents('php://input'), true);

$packageId = intval($data['package_id']);

// Get package details
$packageResult = $conn->query("SELECT * FROM packages WHERE id = $packageId");
if ($packageResult->num_rows === 0) {
    echo json_encode(['success' => false, 'error' => 'Package not found']);
    exit;
}

$package = $packageResult->fetch_assoc();

$conn->begin_transaction();

try {
    // Record purchase
    $stmt = $conn->prepare("INSERT INTO package_purchases (package_id, orders_count, price, status) VALUES (?, ?, ?, 'completed')");
    $ordersCount = $package['orders_count'];
    $price = $package['price'];
    $stmt->bind_param('iid', $packageId, $ordersCount, $price);
    $stmt->execute();
    
    // Add orders to remaining count
    $conn->query("UPDATE config SET package_orders_remaining = package_orders_remaining + $ordersCount, plan = 'package'");
    
    $conn->commit();
    
    echo json_encode([
        'success' => true,
        'message' => "Successfully purchased {$package['name']}! {$ordersCount} orders added."
    ]);
    
} catch (Exception $e) {
    $conn->rollback();
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}

$conn->close();
?>