<?php
require_once 'config.php';

$conn = getDB();

$method = $_SERVER['REQUEST_METHOD'];

// GET - Load all menu items
if ($method === 'GET') {
    $result = $conn->query("SELECT * FROM menu ORDER BY category, name");
    $menu = [];
    while ($row = $result->fetch_assoc()) {
        $menu[] = $row;
    }
    echo json_encode(['success' => true, 'menu' => $menu]);
    exit;
}

// POST - Add new item
if ($method === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    
    $name = $conn->real_escape_string($data['name']);
    $category = $conn->real_escape_string($data['category']);
    $price = floatval($data['price']);
    $image = $conn->real_escape_string($data['image']);
    $active = $data['active'] ? 1 : 0;
    
    $stmt = $conn->prepare("INSERT INTO menu (name, category, price, image, active) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param('ssdsi', $name, $category, $price, $image, $active);
    $result = $stmt->execute();
    
    echo json_encode(['success' => $result, 'id' => $conn->insert_id]);
    exit;
}

// PUT - Update item
if ($method === 'PUT') {
    $data = json_decode(file_get_contents('php://input'), true);
    
    $id = intval($data['id']);
    $name = $conn->real_escape_string($data['name']);
    $category = $conn->real_escape_string($data['category']);
    $price = floatval($data['price']);
    $image = $conn->real_escape_string($data['image']);
    $active = $data['active'] ? 1 : 0;
    
    $stmt = $conn->prepare("UPDATE menu SET name = ?, category = ?, price = ?, image = ?, active = ? WHERE id = ?");
    $stmt->bind_param('ssdsii', $name, $category, $price, $image, $active, $id);
    $result = $stmt->execute();
    
    echo json_encode(['success' => $result]);
    exit;
}

// DELETE - Delete item
if ($method === 'DELETE') {
    $id = intval($_GET['id']);
    $result = $conn->query("DELETE FROM menu WHERE id = $id");
    echo json_encode(['success' => $result]);
    exit;
}

$conn->close();
?>