<?php
require_once 'config.php';

$conn = getDB();

$table = isset($_GET['table']) ? $conn->real_escape_string($_GET['table']) : '';

if (empty($table)) {
    echo json_encode(['success' => false, 'error' => 'Table name required']);
    exit;
}

// Get today's date
$today = date('Y-m-d');

// Get orders for this table today
$result = $conn->query("
    SELECT * FROM orders 
    WHERE table_name = '$table' 
    AND order_date = '$today' 
    AND status != 'completed'
    ORDER BY timestamp DESC
");

$orders = [];
while ($row = $result->fetch_assoc()) {
    $orders[] = $row;
}

// Get table status
$tableResult = $conn->query("SELECT status FROM tables WHERE name = '$table'");
$tableStatus = $tableResult->num_rows > 0 ? $tableResult->fetch_assoc()['status'] : 'free';

// Get config
$configResult = $conn->query("SELECT shop_name FROM config LIMIT 1");
$config = $configResult->fetch_assoc();

echo json_encode([
    'success' => true,
    'orders' => $orders,
    'table_status' => $tableStatus,
    'shop_name' => $config['shop_name']
]);

$conn->close();
?>