<?php
// Database Configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'coffee_ordering');

// Plan Limits
define('FREE_LIMIT_QR', 5);
define('PRO_LIMIT_QR', 10);
define('ENTERPRISE_LIMIT_QR', 20);

define('FREE_SCAN_LIMIT', 1000);
define('PRO_SCAN_LIMIT', 10000);
define('ENTERPRISE_SCAN_LIMIT', 20000);

// Connect to Database
function getDB() {
    static $conn = null;
    if ($conn === null) {
        $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
        if ($conn->connect_error) {
            die(json_encode(['success' => false, 'error' => 'Database connection failed']));
        }
        $conn->set_charset('utf8mb4');
    }
    return $conn;
}

// Get Plan Limits
function getPlanLimits($plan) {
    switch($plan) {
        case 'free':
            return ['qr' => FREE_LIMIT_QR, 'scan' => FREE_SCAN_LIMIT];
        case 'pro':
            return ['qr' => PRO_LIMIT_QR, 'scan' => PRO_SCAN_LIMIT];
        case 'enterprise':
            return ['qr' => ENTERPRISE_LIMIT_QR, 'scan' => ENTERPRISE_SCAN_LIMIT];
        default:
            return ['qr' => FREE_LIMIT_QR, 'scan' => FREE_SCAN_LIMIT];
    }
}

// Check and Reset Monthly Scan Count
function checkResetScanCount($conn) {
    $result = $conn->query("SELECT last_reset_date FROM config LIMIT 1");
    if ($result && $row = $result->fetch_assoc()) {
        $lastReset = $row['last_reset_date'];
        $currentMonth = date('Y-m');
        $lastResetMonth = date('Y-m', strtotime($lastReset));
        
        if ($currentMonth != $lastResetMonth) {
            $conn->query("UPDATE config SET current_month_scan_count = 0, last_reset_date = CURDATE()");
        }
    }
}

// CORS Headers
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}
?>