<?php
$table = isset($_GET['table']) ? htmlspecialchars($_GET['table']) : 'Unknown';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage <?php echo $table; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <div id="tableDetailApp">
        <div class="admin-header">
            <div class="container">
                <a href="index.php" class="back-btn">← Back to Dashboard</a>
                <h1 id="tableTitle"><?php echo $table; ?></h1>
            </div>
        </div>

        <div class="container">
            <div class="section">
                <div class="flex-between">
                    <h2>Orders</h2>
                    <div class="total-display" id="tableTotal">$0.00</div>
                </div>
                <div id="ordersList"></div>
            </div>

            <div class="action-buttons">
                <button id="payingBtn" class="btn btn-paying">Mark as Paying</button>
                <button id="freeBtn" class="btn btn-free">Complete & Free Table</button>
            </div>
        </div>
    </div>

    <script>
        const TABLE_NAME = "<?php echo $table; ?>";
    </script>
    <script src="../assets/js/admin-table.js"></script>
</body>
</html>