<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <div id="settingsApp">
        <div class="admin-header">
            <div class="container">
                <a href="index.php" class="back-btn">← Back to Dashboard</a>
                <h1>Settings</h1>
            </div>
        </div>

        <div class="container">
            <!-- Shop Settings -->
            <div class="section">
                <h2>Shop Settings</h2>
                <form id="shopSettingsForm">
                    <div class="form-group">
                        <label>Shop Name</label>
                        <input type="text" id="shopName" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Tax Percent (%)</label>
                        <input type="number" id="taxPercent" class="form-control" step="0.01" min="0" max="100" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Save Settings</button>
                </form>
            </div>

            <!-- Package Management -->
            <div class="section">
                <h2>Order Packages</h2>
                <div class="package-info">
                    <div class="info-card">
                        <div class="info-label">Current Plan</div>
                        <div class="info-value" id="currentPlan">Loading...</div>
                    </div>
                    <div class="info-card">
                        <div class="info-label">Orders Remaining</div>
                        <div class="info-value" id="ordersRemaining">0</div>
                    </div>
                </div>
                
                <h3 style="margin-top: 30px;">Purchase Package</h3>
                <div id="packagesList" class="packages-grid"></div>
            </div>

            <!-- Menu Management -->
            <div class="section">
                <div class="flex-between" style="margin-bottom: 20px;">
                    <h2>Menu Management</h2>
                    <button class="btn btn-primary" onclick="showAddItemModal()">+ Add Item</button>
                </div>
                <div id="menuList"></div>
            </div>
        </div>
    </div>

    <!-- Add/Edit Item Modal -->
    <div id="itemModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h2 id="modalTitle">Add Menu Item</h2>
                <span class="close" onclick="closeModal()">&times;</span>
            </div>
            <form id="itemForm">
                <input type="hidden" id="itemId">
                <div class="form-group">
                    <label>Item Name</label>
                    <input type="text" id="itemName" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Category</label>
                    <input type="text" id="itemCategory" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Price ($)</label>
                    <input type="number" id="itemPrice" class="form-control" step="0.01" min="0" required>
                </div>
                <div class="form-group">
                    <label>Image URL</label>
                    <input type="text" id="itemImage" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" id="itemActive" checked>
                        Active
                    </label>
                </div>
                <div style="display: flex; gap: 10px;">
                    <button type="submit" class="btn btn-primary" style="flex: 1;">Save</button>
                    <button type="button" class="btn btn-secondary" onclick="closeModal()" style="flex: 1;">Cancel</button>
                </div>
            </form>
        </div>
    </div>

    <script src="../assets/js/settings.js"></script>
</body>
</html>